import { world, system } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";


world.afterEvents.playerInteractWithEntity.subscribe(event => {
    const { player, target } = event;
    if (!target || target.typeId !== "hivehub:game_build") return;

    plnayer(player);
});


world.afterEvents.entityHitEntity.subscribe(event => {
    const { damagingEntity, hitEntity } = event;
    if (!(damagingEntity?.typeId === "minecraft:player")) return;
    if (!hitEntity || hitEntity.typeId !== "hivehub:game_build") return;

    plnayer(damagingEntity);
});



function plnayer(player) {
	const over = world.getDimension("minecraft:overworld");
	player.playSound("random.pop2");
        new ActionFormData()
            .title("§lPLACES")
            .body('Choose where you wanna Teleport!')
            .button('§l§8GarBage Bank\n§r§7[ Click to Teleport ]', "textures/ui/icon_trash")
            .button('§l§dShulker Box Place\n§r§7[ Click to Teleport ]', "textures/items/shulker_box")
            .button('§l§bAdmin Shop\n§r§7[ Click to Teleport ]', "textures/ui/admin")
            .button('§l§eRelaxing Park\n§r§7[ Click to Teleport ]', "textures/ui/relaxing")
            .button('§l§3School §e& §bNeighbourhood\n§r§7[ Click to Teleport ]', "textures/ui/school")
            .button('§l§tThe Land\n§r§7[ Click to Teleport ]', "textures/ui/welcome")
            .show(player).then(r => {
                if (r.selection == 0) {
                    over.runCommandAsync(`tp "${player.name}" 1000 5 1000 facing 1000 5 1001`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
                if (r.selection == 1) {
                over.runCommandAsync(`tp "${player.name}" -5000 4 -5000 facing -5000 4 -4999`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
            }
                if (r.selection == 2) {
                    over.runCommandAsync(`tp "${player.name}" 3000 4 3000 facing 3000 4 2999`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
                if (r.selection == 3) {
                over.runCommandAsync(`tp "${player.name}" -3000 4 -3000 facing -3000 4 -3001`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
            }
                if (r.selection == 4) {
                    over.runCommandAsync(`tp "${player.name}" -1967 4 1876 facing -1966 4 1876`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
                if (r.selection == 5) {
                    player.sendMessage("§cThe Land is temporary unavailable!")
                    player.playSound("note.bass");
                }
            })
    }
    

